#include "ScnMoreOptions.h"
#include "freestyledash.h"

HRESULT CScnMoreOptions::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
    GetChildById( L"FanSpeed", &m_FanSpeed );
    GetChildById( L"FanSpeedText", &m_FanSpeedText );
	GetChildById( L"PlayerLedType", &m_PlayerLedType );
	GetChildById( L"ReloadPrompt", &m_ReloadPrompt );

	m_ReloadPrompt.SetShow(false);
	m_FanSpeed.SetValue(FSpeed);

	for (int i = 0 ; i < 5 ; i++)
	{
		m_PlayerLedType.SetItemCheck(i,FALSE);
	}
	m_PlayerLedType.SetItemCheck(LedType,TRUE);

	SetTimer(TM_FAN_SPEED,500);

	if (FSpeed <= 40)
	{
		SpeedText = sprintfa(L"Auto");
	}
	else
	{
		SpeedText = sprintfa(L"%d%%", FSpeed);
	}

	m_FanSpeedText.SetText(SpeedText.c_str());

	return S_OK;
}

HRESULT CScnMoreOptions::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
    // which timer is it?
    switch( pTimer->nId )
    {
        case TM_FAN_SPEED:
		{
			int OldSpeed = FSpeed;

			m_FanSpeed.GetValue(&FSpeed);

			if (OldSpeed != FSpeed)
			{
				DoSaveSettings();

				SetFanSpeed(1,FSpeed);

				if (FSpeed <= 40)
				{
					SpeedText = sprintfa(L"Auto");
				}
				else
				{
					SpeedText = sprintfa(L"%d%%", FSpeed);
				}

				m_FanSpeedText.SetText(SpeedText.c_str());
			}
			break;
		}
    }
    
    bHandled = TRUE;
    
    return( S_OK );
}

HRESULT CScnMoreOptions::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{
	if (hObjPressed == m_PlayerLedType)
	{
		LedType = m_PlayerLedType.GetCurSel();

		for (unsigned int i = 0 ; i < 5 ; i++)
		{
			m_PlayerLedType.SetItemCheck(i,FALSE);
		}

		m_PlayerLedType.SetItemCheck(LedType,TRUE);
		

		if (LedType == 1) //Temp Led
		{
			SetTempLEDS();

			m_ReloadPrompt.SetShow(true);
		} 
		else
		{
			SetLedState(LedType);

			m_ReloadPrompt.SetShow(false);
		}
		
		DoSaveSettings();
	}


    return S_OK;
}